## 2. 使用LabelMe标注「目标检测」及「实例分割」任务数据

### 2.1 准备工作     

* **2.1.1** 创建与图像文件夹相对应的文件夹，用于存储标注的json文件。
* **2.1.2**点击”Open Dir“按钮，选择需要标注的图像所在的文件夹打开，则”File List“对话框中会显示所有图像所对应的绝对路径。      

### 2.2 目标检测标注    

* **2.2.1** 打开矩形框标注工具，具体如下图所示     

<div align=center><img width="800" height="450" src="./pics/detection1.png"/></div>        

* **2.2.2** 使用拖拉的方式对目标物体进行标识，并在弹出的对话框中写明对应label（当label已存在时点击即可），具体如下图所示：    

<div align=center><img width="800" height="450" src="./pics/detection3.png"/></div>        

当框标注错误时，可点击右侧的“Edit Polygons”再点击标注框，通过拖拉进行修改，也可再点击“Delete Polygon”进行删除。       

* **2.2.3** 点击右侧”Save“，将标注结果保存到***2.1.1***中创建的文件夹中
  【注意】当所使用的模型是类似Mask R-CNN这类模型时，虽是目标检测模型，但却需要实例分割信息，具体参见***2.3***。

### 2.3 实例分割标注     

* **2.3.1** 点击右侧的“Create Polygons”以打点的方式圈出目标的轮廓，并在弹出的对话框中写明对应label（当label已存在时点击即可），具体如下提所示：

<div align=center><img width="800" height="450" src="./pics/detection2.png"/></div>      

当框标注错误时，可点击右侧的“Edit Polygons”再点击标注框，通过拖拉进行修改，也可再点击“Delete Polygon”进行删除。          

* **2.3.2** 点击右侧”Save“，将标注结果保存到***2.1.1***中创建的文件夹中。       

【注意】***2.2.2***和***2.3.1***中在在定义label名字时，都用英文命名，同时在名字后加上“_0”或“_1”分别代表目标是一个对象（iscrowd=0）还是一组对象（iscrowd=1）。一个对象表示能用一个矩形框（或大于等于一个多边形框）就能将一个独立对象表示出来，当需要使用多个多边形来表示一个对象时，在“_0”后加上同一个数字代表同一个对象；一组对象表示同一类型对象联系太紧密只能用一个矩形框（或一个多边形框）将一组对象圈出来。例如下图在进行目标检测标注时，水果单堆分割成一个个水果较不容易，所以将其定义为一组水果对象，label定为“fruit_1” ；在进行实例分割标注时，装饰品无法用一个多边形框表示出来，所以使用3个label为“decoration_00”的多边形表示。
<div align=center><img width="800" height="450" src="./pics/detection4.png"/></div>   


## 2.4 目标检测任务数据目录结构
```
data/mydataset/
|-- JPEGImages
    |-- 1.jpg 
    |-- 2.jpg
|-- annotations
    |-- 1.xml
    |-- 2.xml
```
其中，annotations文件夹中存放标注文件，JPEGImages文件夹中存放图像文件。        

  

## 2.5 实例分割任务数据目录结构

```
data/mydataset/
|-- JPEGImages
    |-- 1.jpg 
    |-- 2.jpg
|-- annotations.json  
```

其中，`annotations.json`为标注文件，JPEGImages文件夹中存放图像文件。            

